<?php
include ('includes/header.php');
$configFile = './api/config.json';
$configContents = file_get_contents($configFile);
$config = json_decode($configContents, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $config['app_conf'] = array_merge($config['app_conf'], $_POST['app_conf']);
    $newConfigContents = json_encode($config, JSON_PRETTY_PRINT);
    file_put_contents($configFile, $newConfigContents);
    echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}


$itemsPerPage = 30; 
$totalItems = count($config['app_conf']); 
$totalPages = ceil($totalItems / $itemsPerPage); 
$currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1; 
$startIndex = ($currentPage - 1) * $itemsPerPage; 

$displayItems = array_slice($config['app_conf'], $startIndex, $itemsPerPage, true);
?>



<div class="col-md-12 mx-auto">
            <div class="card-body">
                <div class="card bg-primary text-white">
                    <div class="card-header card-header-warning">
                        <center>
                            <h2><i class="icon icon-commenting"></i> App Config</h2>
                            <h4> Please note: Some settings are not compatible with Easy Player.</h4>
                        </center>
                    </div>

                    <div class="card-body">
<div class="container">
    <form method="POST" class="w-100">

        <div class="row">
            <?php foreach ($displayItems as $key => $value): ?>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="<?= $key ?>"><?= ucfirst(str_replace('_', ' ', $key)) ?>:</label>
                        <?php
                        if ($value === "true" || $value === "false"): ?>
                            <select name="app_conf[<?= $key ?>]" class="form-control">
                                <option value="true" <?= $value === "true" ? 'selected' : '' ?>>True</option>
                                <option value="false" <?= $value === "false" ? 'selected' : '' ?>>False</option>
                            </select>
                        <?php else: ?>
                            <input type="text" name="app_conf[<?= $key ?>]" value="<?= htmlspecialchars($value) ?>" class="form-control">
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <button type="submit" name="submit" class="btn btn-secondary">Save Changes</button>
    </form>
    <br>
    <!-- Pagination Controls -->
    <nav aria-label="Page navigation example">
      <ul class="pagination">
        <?php if ($currentPage > 1): ?>
        <li class="page-item"><a class="page-link" href="?page=<?= $currentPage - 1 ?>">Previous</a></li>
        <?php endif; ?>

        <?php for ($page = 1; $page <= $totalPages; $page++): ?>
        <li class="page-item <?= $page == $currentPage ? 'active' : '' ?>"><a class="page-link" href="?page=<?= $page ?>"><?= $page ?></a></li>
        <?php endfor; ?>

        <?php if ($currentPage < $totalPages): ?>
        <li class="page-item"><a class="page-link" href="?page=<?= $currentPage + 1 ?>">Next</a></li>
        <?php endif; ?>
      </ul>
    </nav>
</div>
</div>
</body>
</html>
<?php include ('includes/footer.php');?>